--
--c_shader_light.lua
-- 

local isLightOn = false
-- don't mess with the shader tables
local light_shader = {}
local flashlight = {}
local shader_jaroovka = {}
local shader_rays = {}
local isFlon = {}  -- a list of players with fl turned on (for client)
local switch_key = 'r' -- define the key that switches the light effect
local lightColor = {1,1,0.7,0.7} -- rgba color of the projected light, light rays and the lightbulb
local effectRange = 50 -- effect max distance 120
local isFakeBump = false -- apply fake bumps to the light texture
local maxEffectSwitch=60 -- max distance between camera and player coords form which the effect is switched off
local DistFade = {110, 80, 49, 1} -- [0]MaxEffectFade,[1]MinEffectFade,[2]MaxFlashFade,[3]MinFlashFade
local objID = 15060  -- the object we are going to replace (interior building shadow in this case)
local theTikGap = 0.8 -- here you set how many seconds to wait after switching the flashlight on/off
local getLastTick = getTickCount ( )-(theTikGap*1000)
local isLightDir=true -- the vertexes oposite to the lightsource will NOT be affected
local lightDirAcc = 0.2 -- the accuracy of the above (0.01-1)

local textureCube= dxCreateTexture ( "textures/cubebox.dds")

--This part might be useful for some.
--local i_hate_grass = dxCreateShader ( "shaders/shader_null.fx" )
--engineApplyShaderToWorldTexture ( i_hate_grass, "txgrass0*" )

---------------------------------------------------------------------------------------------------
local removeList = {
						"",												-- unnamed
						"basketball2","skybox_tex", "drvin_screen",		-- other
						"flashlight*","crackedground*",					-- other
						"roughcornerstone*",     						-- other
						"muzzle_texture*",								-- gunshots
						"font*","radar*",								-- hud
						"*headlight*",	 								-- vehicles
						"*shad*",										-- shadows
						"coronastar","coronamoon","coronaringa",		-- coronas
						"lunar",										-- moon
						"tx*",											-- grass effect
						"lod*",											-- lod models
						"cj_w_grad",									-- checkpoint texture
						"*cloud*",										-- clouds
						"*smoke*",										-- smoke
						"sphere_cj",									-- nitro heat haze mask
						"particle*",									-- particle skid and maybe others
						"water*","sw_sand", "coral",					-- sea
						"boatwake*","splash_up","carsplash_*",			-- splash
						"gensplash","wjet4","bubbles",					-- splash
						"blood*",										-- blood

					}

---------------------------------------------------------------------------------------------------
--Updates light positions and rotation of the light direction
function renderLight()
for index,thisPed in ipairs(getElementsByType("player")) do
	if light_shader[thisPed] and isElementStreamedIn(thisPed) then
		xx1, yy1, zz1, lxx1, lyy1, lzz1,rl = getCameraMatrix()
		x1, y1, z1 = getPedBonePosition ( thisPed, 24 )
		lx1, ly1, lz1 = getPedBonePosition ( thisPed, 25 )

		local yaw = math.atan2(lx1-x1,ly1-y1) 
		local pitch = (math.atan2(lz1-z1, math.sqrt(((lx1-x1) * (lx1-x1)) + ((ly1-y1) * (ly1-y1))))) 
		local roll = 0
		local movx=xx1-x1 
		local movy=yy1-y1
		local movz=zz1-z1	   
		
		dxSetShaderValue ( light_shader[thisPed],"rotate",yaw,roll,pitch)	
		dxSetShaderValue(light_shader[thisPed],"alterPosition",movx,movy,movz)
		end											
	end
end

---------------------------------------------------------------------------------------------------

function createFlashlightModel(thisPed)

if not flashlight[thisPed] then			
	flashlight[thisPed] = createObject(objID,0,0,0,0,0,0,true)
	exports.bone_attach:attachElementToBone(flashlight[thisPed],thisPed,12,0,0.015,0.2,0,0,0) 
	end
end

function destroyFlashlightModel(thisPed)
if flashlight[thisPed] then			
	exports.bone_attach:detachElementFromBone(flashlight[thisPed])
	destroyElement(flashlight[thisPed])
	flashlight[thisPed]=nil
	end
end

---------------------------------------------------------------------------------------------------

function createWorldLightShader(thisPed)
if light_shader[thisPed] then return false end
	light_shader[thisPed] = dxCreateShader ( "shaders/shader_light.fx",1,effectRange,true,"world,object,vehicle,ped")
	if not light_shader[thisPed] then return false end
	dxSetShaderValue ( light_shader[thisPed],"sCubeTexture", textureCube )
	dxSetShaderValue ( light_shader[thisPed],"isLightDir", isLightDir )
	dxSetShaderValue ( light_shader[thisPed],"isFakeBump", isFakeBump )
	dxSetShaderValue ( light_shader[thisPed],"lightColor",lightColor)
	dxSetShaderValue ( light_shader[thisPed],"lightDirAcc", lightDirAcc )
	dxSetShaderValue ( light_shader[thisPed],"DistFade",DistFade)
	engineApplyShaderToWorldTexture ( light_shader[thisPed], "*" )

	-- remove light effect from the texture list
	for _,removeMatch in ipairs(removeList) do
		engineRemoveShaderFromWorldTexture ( light_shader[thisPed], removeMatch )	
		end	
return true		
end

function destroyWorldLightShader(thisPed)
if light_shader[thisPed] then
	engineRemoveShaderFromWorldTexture ( light_shader[thisPed], "*" )
	destroyElement ( light_shader[thisPed] )
	light_shader[thisPed]=nil
	dxSetShaderValue(shader_jaroovka[thisPed],"isFLon",false)						
	dxSetShaderValue(shader_rays[thisPed],"isFRon",false)
	return true
	else
	return false
	end
end

---------------------------------------------------------------------------------------------------

function createFlashLightShader(thisPed)
if not shader_jaroovka[thisPed] then
	shader_jaroovka[thisPed]=dxCreateShader("shaders/shader_jaroovka.fx",0,0,false)
	shader_rays[thisPed]=dxCreateShader("shaders/flash_light_rays.fx",0,0,false)
	if not shader_jaroovka[thisPed] or not shader_rays[thisPed] then
		outputChatBox( "Could not create shader. Please use debugscript 3" )
	end
			
	engineApplyShaderToWorldTexture ( shader_jaroovka[thisPed],"flashlight_L", flashlight[thisPed] )
	engineApplyShaderToWorldTexture ( shader_rays[thisPed], "flashlight_R", flashlight[thisPed] )	
	dxSetShaderValue (shader_jaroovka[thisPed],"isFLon",false)						
	dxSetShaderValue (shader_rays[thisPed],"isFRon",false)
	dxSetShaderValue (shader_jaroovka[thisPed],"lightColor",lightColor)
	dxSetShaderValue (shader_rays[thisPed],"lightColor",lightColor)	
	end
end

function destroyFlashLightShader(thisPed)
if shader_jaroovka[thisPed] or shader_rays[thisPed] then
	dxSetShaderValue (shader_jaroovka[thisPed],"isFLon",false)
	dxSetShaderValue (shader_rays[thisPed],"isFRon",false)	
	destroyElement(shader_jaroovka[thisPed])
	destroyElement(shader_rays[thisPed])
	shader_jaroovka[thisPed]=nil
	shader_rays[thisPed]=nil
	end
end

---------------------------------------------------------------------------------------------------

function flashLightEnable(isEN,this_player)
if isEN==true then
	if not flashlight[this_player] then 
		createFlashlightModel(this_player)  
		createFlashLightShader(this_player) 
		end
	else
		if flashlight[this_player] then
			destroyFlashLightShader(this_player)
			destroyFlashlightModel(this_player)
		end
	end
end

function playSwitchSound(this_player)
pos_x,pos_y,pos_z=getElementPosition (this_player)
local flSound = playSound3D("sounds/switch.wav", pos_x, pos_y, pos_z, false) 
setSoundMaxDistance(flSound,40)
setSoundVolume(flSound,0.6)
end


function flashLightSwitch(isON,this_player)
--local sPlayerNickname = getPlayerName (this_player)
if isON then
	if not light_shader[this_player] then createWorldLightShader(this_player) 
		playSwitchSound(this_player)
		isFlon[this_player]=true 
		if shader_jaroovka[this_player] then dxSetShaderValue(shader_jaroovka[this_player],"isFLon",true) end						
		if shader_rays[this_player] then dxSetShaderValue (shader_rays[this_player],"isFRon",true) end
		--outputChatBox('The player: '..sPlayerNickname..' turned on the flashlight.')
	 end

else
	if light_shader[this_player] then destroyWorldLightShader(this_player) playSwitchSound(this_player) end
		isFlon[this_player]=false 	
		if shader_jaroovka[this_player] then dxSetShaderValue(shader_jaroovka[this_player],"isFLon",false) end						
		if shader_rays[this_player] then dxSetShaderValue (shader_rays[this_player],"isFRon",false) end
		--outputChatBox('The player: '..sPlayerNickname..' turned off the flashlight.')
		
	end
end

function whenPlayerQuits(this_player)
destroyWorldLightShader(this_player) 
destroyFlashlightModel(this_player) 
destroyFlashLightShader(this_player)  
end


function streamInAndOut()
for index,this_player in ipairs(getElementsByType("player")) do
	local cam_x, cam_y, cam_z, _, _, _ = getCameraMatrix()
	local player_x,player_y,player_z = getElementPosition(this_player)
	local getDist = getDistanceBetweenPoints3D(cam_x,cam_y,cam_z,player_x,player_y,player_z)
	--local sPlayerNickname = getPlayerName (this_player)
	if isElementStreamedIn(this_player) and not light_shader[this_player] and isFlon[this_player]==true and getDist<=maxEffectSwitch then 
		createWorldLightShader(this_player) 
		dxSetShaderValue(shader_jaroovka[this_player],"isFLon",true)						
		dxSetShaderValue (shader_rays[this_player],"isFRon",true) 
		--outputChatBox('Streaming in a light bearer: '..sPlayerNickname)  
		end
	if (not isElementStreamedIn(this_player) or getDist>maxEffectSwitch) and light_shader[this_player] and isFlon[this_player]==true then 
		destroyWorldLightShader(this_player) 
		dxSetShaderValue(shader_jaroovka[this_player],"isFLon",true)						
		dxSetShaderValue (shader_rays[this_player],"isFRon",true) 
		--outputChatBox('Streaming out a light bearer: '..sPlayerNickname)  
		end
	end
end

-- switch on or off
function toggleLight()
if (getTickCount ( ) - getLastTick < theTikGap*1000) then outputChatBox('FL: Wait '..theTikGap..' seconds.',255,0,100) return end
if isLightOn==false then isLightOn=true else isLightOn=false end
triggerServerEvent("onSwitchLight",getLocalPlayer(),isLightOn)
getLastTick = getTickCount ( )
end

-- start or stop using flashlight
function toggleFlashLight()
if flashlight[getLocalPlayer()] then 
	--outputChatBox('You have switched off the flashlight')
	triggerServerEvent("onSwitchLight",getLocalPlayer(),false)
	triggerServerEvent("onSwitchEffect",getLocalPlayer(),false)
	unbindKey(switch_key,"down",toggleLight)
else
	--outputChatBox('You have switched on the flashlight')
	triggerServerEvent("onSwitchLight",getLocalPlayer(),false)
	triggerServerEvent("onSwitchEffect",getLocalPlayer(),true)
	bindKey(switch_key,"down",toggleLight)
	end
end

---------------------------------------------------------------------------------------------------
		
function shaderResourceStart()

local ver = getVersion ().sortable
local build = string.sub( ver, 9, 13 )
if build<"04938" or ver < "1.3.1" then 
	outputChatBox('The resource is not compatible with this client version!')
	return
	end

outputChatBox('Type /flashlight to enable the flashlight , hit '..switch_key..' to turn on/off');

engineImportTXD( engineLoadTXD( "objects/flashlight.txd" ), objID ) 
engineReplaceModel ( engineLoadDFF( "objects/flashlight.dff", 0 ), objID,true)
addEventHandler("onClientPreRender", root, renderLight)
addEventHandler("onClientPreRender", root, streamInAndOut)
triggerServerEvent("onPlayerStartRes",getLocalPlayer())
addCommandHandler("flashlight",toggleFlashLight)
end

---------------------------------------------------------------------------------------------------

addEventHandler("onClientResourceStart", getResourceRootElement( getThisResource()), shaderResourceStart)

addEvent( "flashOnPlayerEnable", true )
addEvent( "flashOnPlayerQuit", true )
addEvent( "flashOnPlayerSwitch", true )
addEventHandler( "flashOnPlayerQuit", getResourceRootElement( getThisResource()), whenPlayerQuits)
addEventHandler( "flashOnPlayerSwitch", getResourceRootElement( getThisResource()), flashLightSwitch)
addEventHandler( "flashOnPlayerEnable", getResourceRootElement( getThisResource()), flashLightEnable)
