﻿local checkTimers = {};
local checkTimerDuration = 60 * 1; --1 minute check
local blockDuration = 1200 * 1; --4 hours (Для тестов: значение 60 [1 минута])

addEventHandler( 'onResourceStart', resourceRoot, function()
  for i, player in ipairs( getElementsByType( 'player' ) ) do
    checkTimers[ player ] = setTimer( checkPlayerVIPDataLockState, checkTimerDuration, 0, player );
  end;
end );

addEventHandler( 'onPlayerJoin', root, function()
  checkTimers[ source ] = setTimer( checkPlayerVIPDataLockState, checkTimerDuration, 0, source );
end );

addEventHandler( 'onPlayerQuit', root, function()
  if isTimer( checkTimers[ source ] ) then
    killTimer( checkTimers[ source ] );
    checkTimers[ source ] = nil;
  end;
end );

function checkPlayerVIPDataLockState( player )
  local acc = getPlayerAccount( player );
  if isGuestAccount( acc ) then return false; end;
  
  local time_end = getAccountData( acc, 'ucb_time' );
  
  if not time_end or not tonumber( time_end ) or time_end == '' then
    return false;
  end;
  
 -- if getRealTime()[ 'timestamp' ] >= tonumber( time_end ) then
    --setPlayerVIPDataLocked( player, false );
  --end;
end;

function getPlayerVIPDataLockState( player )
  local acc = getPlayerAccount( player );
  if isGuestAccount( acc ) then return false; end;
  
  local time_end = getAccountData( acc, 'ucb_time' );
  
  if not time_end or not tonumber( time_end ) or time_end == '' then
    return false;
  end;
  
  return getRealTime()[ 'timestamp' ] < tonumber( time_end );
end;

function setPlayerVIPDataLockState( player, state )
  local acc = getPlayerAccount( player );
  if isGuestAccount( acc ) then return false; end;
  
  setAccountData( acc, 'ucb_time', (state == true and (getRealTime()[ 'timestamp' ] + blockDuration) or nil) );
end;

function showPanel2(thePlayer)
    accountname = getAccountName (getPlayerAccount(thePlayer))
    if isObjectInACLGroup ( "user." .. accountname, aclGetGroup ( "VIP" ) ) then
    triggerClientEvent (thePlayer, "ShowGUI", getRootElement())
    else
    outputChatBox("#ff6464Только VIP игрок может открыть панель.",thePlayer,255,125,0,true)
    end
end

function onResStart ()
    for index, player in ipairs ( getElementsByType ( "player" ) ) do
        bindKey ( player, "F10", "down", showPanel2 )
    end
end
addEventHandler ( "onResourceStart", getResourceRootElement ( getThisResource() ), onResStart)

function onPlayerJoin ()
    bindKey ( source, "F10", "down", showPanel2 )
end
addEventHandler ( "onPlayerJoin", getRootElement(), onPlayerJoin)

function cleanAll (player)
    for index, player in ipairs ( getElementsByType ( "player" ) ) do
        unbindKey ( player, "F10", "down", showPanel2 )
    end
end
addEventHandler ( "onResourceStop", getResourceRootElement ( getThisResource() ), cleanAll)


----------------------------------------------------------------------------------------------------

function BuyWeaponOnServer()
      if not getPlayerVIPDataLockState( client ) then
          setElementData(source, "MAX_Slots" ,300 )
          setElementData(source, "M240", 1)
          setElementData(source, "M240 Mag", 300)
          setElementData(source, "M107", 1)
          setElementData(source, "M107 Mag", 120)
          setElementData(source, "M4A1 CCO", 1)
          setElementData(source, "M4A1 CCO Mag", 300)	  
          setElementData(source, "Bizon SD", 1)
          setElementData(source, "Bizon SD Mag", 200)
          setElementData(source, "Слезоточивый Газ", 3)
          setElementData(source, "Граната", 3)	
          setElementData(source, "Банка бобов", 10)
          setElementData(source, "Молоко", 10) 
          setElementData(source, "Химсвет.Белый", 5)
		  setElementData(source, "Химсвет.Синий", 5)
		  setElementData(source, "Химсвет.Красный", 5)
          setElementData(source, "Полная канистра", 3)
          setElementData(source, "Аптечка", 3)
          setElementData(source, "Грелка", 3)
          setElementData(source, "Болеутоляющие", 3)
          setElementData(source, "Морфий", 3)
          setElementData(source, "Колючая проволка", 3)
          setElementData(source, "Колеса", 8)
          setElementData(source, "Двигатель", 2)
          setElementData(source, "Бензобак", 2)
          setElementData(source, "Доллары", 100000)	  
          setElementData(source, "Пулемет (Машинный)", 1)
          setElementData(source, "Глушитель", 1)
          setElementData(source, "Патроны для пулемета (Машинный)", 10)
          setElementData(source, "Палатка", 1)
          setElementData(source, "Мина", 1)
          setElementData(source, "Шлем штурмовика", 1)
          setElementData(source, "Бронежилет (Arial)", 1)	  
          setElementData(source, "Скин священника", 1)
          setElementData(source, "Лиственный скин", 1)
          setElementData(source, "Скин полицейского", 1)
          setElementData(source, "Скин снайпера", 1)	  
          setElementData(source, "ПНВ", 1)
          setElementData(source, "ИНФ", 1)
          setElementData(source, "Карта местности", 1)
          setElementData(source, "Спички", 1)
          setElementData(source, "Часы", 1)
          setElementData(source, "GPS", 1)
          setElementData(source, "Инструменты", 1)
          outputChatBox("#FFff00[Вип панель] #FFFFFFНабор штурмовика выдан", source, 255, 255, 255 , true)
          setPlayerVIPDataLockState( client, true );
      else
          outputChatBox( "#FFff00[V.I.P] #FFFFFFЭту возможность можно использовать 1 раз в 20 минут!", client, 255, 0, 0, true )
      end
end
addEvent("onClientGiveWeapon", true)
addEventHandler("onClientGiveWeapon", getRootElement(), BuyWeaponOnServer)